// JavaScript Document

function OpenWin(url,width,height) {
	newWindow = window.open(url,"NewWindow","toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=yes,width="+width+",height="+height)
}

var error = "";
var rfString = "";
var form = "";
function ValidateForm(form) {
	error = "";
	for (i=0; i<form.elements.length; i++) {
		// FIRST CHECK TO SEE IF REQUIRED FIELDS EXIST
		if (form.elements[i].name.indexOf("reqfields") != -1) {
			rfString = form.reqfields.value;
			break;
		}
	}
	if (rfString) {
		validateReqFields(form)
	}
	else {
		validateAllFields(form)
	}
	if (error) {
		alert('This form could not be processed because of the following errors:\n\n' + error);
		return false;
	}
}

function validateReqFields(form) {
	rfString = form.reqfields.value;
	rfArray = rfString.split(",");
	rfCount = rfArray.length-1;
	rnametemp = "";
	for (x=0; x<=rfCount; x++) {
		for (i=0; i < form.elements.length; i++) {
			if (form.elements[i].name == rfArray[x]) {
				if ((form.elements[i].type == 'radio' || form.elements[i].type == 'checkbox') && rnametemp != form.elements[i].name) {
					rnametemp = form.elements[i].name;
					checkRadio(rnametemp,form);
				}
				else if (form.elements[i].name.indexOf("email") != -1) {
					checkEmail(form.elements[i].value)
					}
				else if (form.elements[i].value == "") {
					if (form.elements[i].name == rfArray[x]) {
						error = error + '* ' + form.elements[i].name + ' is empty\n'
					}
				}
			}
		}
	}
}

function validateAllFields(form) {
	rnametemp = "";
	for (i=0; i < form.elements.length; i++) {
		if (form.elements[i].type == 'radio' && rnametemp != form.elements[i].name) {
			rnametemp = form.elements[i].name;
			checkRadio(rnametemp,form);
		}
		else if (form.elements[i].name.indexOf("email") != -1) {
			checkEmail(form.elements[i].value)
			}
		else if (form.elements[i].value == "") {
			error = error + '* ' + form.elements[i].name + ' is empty\n'
		}
	}
}

function checkEmail (strng) {
//var error="";
if (strng == "") {
   error = error + "* You didn't enter an email address.\n";
}
else {
    var emailFilter=/^.+@.+\..{2,3}$/;
    if (!(emailFilter.test(strng))) { 
       error = error + "* Please enter a valid email address.\n";
    }
    else {
//test email for illegal characters
       var illegalChars= /[\(\)\<\>\,\;\:\\\"\[\]]/
         if (strng.match(illegalChars)) {
          error = error + "* The email address contains illegal characters.\n";
       }
    }
}
return error;    
}

function checkRadio(fname,form) {
	valcheck = "";
	alMsg = "";
	maxnum = form.elements[fname].length
	for (z=0;z<maxnum;z++) {
		if (form.elements[fname][z].checked) {
			valcheck = "1";
			break;
		}
	}
	if (!valcheck) {
		error = error + '* ' + fname + ' is not checked\n';
	}
}



function showHide(element,eList) {
	//eList = "mainphoto,hall1,hall2,hall3,oldcourse,rainbow,hole17,hole18,hole18-2";
	lArray = eList.split(",");
	for (i=0;i<lArray.length;i++) {
		document.getElementById(lArray[i]).style.display = "none";
	}
	document.getElementById(element).style.display = "block";
}

function changeLayout(img,bk) {
	if (bk) {
		//document.getElementById("bodyx").style.background="url(tempdesigns/" + bk + ")";
		document.getElementById("bodyx").style.background=bk;
	}
	if (img) {
		showHide(img,eList);
	}
}

function changeImg(img,imgSrc) {
	document.getElementById(img).src="images/"+imgSrc;
}

function dropDown(dd,img) {
	mlist = "menu,seasonal,xx";
	
	
	if (imgSrc == "arrow.gif") {
		imgSrc = "arrow2.gif";
		showHide(dd,mlist);
	}
	else {
		imgSrc = "arrow.gif";
		ShowHide('xx',mlist);
	}
	document.getElementById(img).src="images/"+imgSrc;
	
	
}

mlist = "menu,seasonal";
function switchOn(dd,img) {
	if (document.getElementById(img).src.indexOf("arrow.gif") != -1) {
		document.getElementById(img).src = "images/arrow2.gif"
		showHide(dd,mlist);
	}
	else {
		document.getElementById(img).src = "images/arrow.gif"
		showHide('xx',mlist);
		//alert(document.getElementById(img).src);
	}
}
function switchOff(img) {
	document.getElementById(img).src = "images/arrow.gif"
	setTimeout("showHide('xx','"+mlist+"')",1000);
	//showHide('xx',mlist);
}

